/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/

package cnrg.itx.signal;

import cnrg.itx.signal.SignalEvent.*;
import cnrg.itx.ds.*;
import cnrg.itx.datax.*;

/** This class provides default implementations for the methods defined in the SignalingObsrver interface.
 */
public class AbstractSignalingObserver implements SignalingObserver
{
	/**
	 * @see cnrg.itx.signal.client.SignalingObserver.onInvite(InviteSignalEvent ise)
	 */
	public void onInvite(InviteSignalEvent se){
	}

	/**
	 * @see cnrg.itx.signal.client.SignalingObserver.onStartCall(SignalConnection sc)
	 */	
	public void onStartCall(SignalConnection sc){
	}
	
	/**
	 * @see cnrg.itx.signal.client.SignalingObserver.onAbortCall(AbortSignalEvent ise)
	 */
	public void onAbortCall(AbortSignalEvent ase){
	}

	/**
	 * @see cnrg.itx.signal.client.SignalingObserver.onHangup(HangupSignalEvent hse)
	 */
	public void onHangup(HangupSignalEvent hse){
	}
	
	/**
	 * @see cnrg.itx.signal.client.SignalingObserver.onInvite(DTMFSignalEvent dtmfse)
	 */
	public void onDTMF(DTMFSignalEvent dtmfse){
	}
}
